//
//  OPApplicationCustomer.h
//  ApplicationFrameworks
//
//  Created by Roustem Karimov on 2014-07-30.
//
//

#import <Foundation/Foundation.h>
#import "OnePasswordCoreConstants.h"

NSSTRING_CONST_EXTERN(kKeychainServiceApplicationCustomer);
NSSTRING_CONST_EXTERN(kKeychainApplicationCustomerIsPremium);

@interface OPApplicationCustomer : NSObject <NSSecureCoding>

+ (OPApplicationCustomer *)sharedCustomer;

@property (nonatomic, assign, getter=isGrandfathered) BOOL grandfathered;
@property (nonatomic, getter = isPremium) BOOL premium;

@property (nonatomic, copy) NSString *originalDownloadDate;
@property (nonatomic, copy) NSString *originalDownloadVersion;
@property (nonatomic, copy) NSString *iapPurchaseDate;
@property (nonatomic, copy) NSString *iapRefundDate;

@property (nonatomic, assign) BOOL isReadyForOrganizePrompt;
@property (nonatomic, assign) BOOL isReadyForMultipleVaultsPrompt;
@property (nonatomic, assign) BOOL isReadyForPremiumCategoriesPrompt;
@property (nonatomic, assign) BOOL isReadyForPremiumItemFeaturesPrompt;
@property (nonatomic, assign) BOOL isReadyForEnhancedSecurityPrompt;

@property (nonatomic, copy) NSString *couponCode;
@property (nonatomic, assign) BOOL hasReceivedCoupon;

- (void)updateFromCustomer:(OPApplicationCustomer *)customer;
- (NSDate *)iapPurchaseDateAsDate;

@end
